var express = require('express');
var app = express();
const path = require('path');
const pg = require('pg');
var cors = require('cors')
const dbConfig = require('../db');
const pool = new pg.Pool(dbConfig);

const checkauth = require('./api/auth/jwt_auth');
const validation = require('./api/middleware/validation');

var bodyParser = require('body-parser');
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
var port = process.env.PORT || 8112;

app.use(cors());
app.use(express.static(path.join(__dirname, 'views')));

const base_img_url = 'http://wealthyfy.ojpasoftware.com:8112/files/upload';

module.exports = {
    base_img_url : base_img_url,
}

pool.connect((err, client, release) => {
    if (err) {
        return console.error(
            'Error acquiring client', err.stack)
    }
    client.query('SELECT NOW()', (err, result) => {
        release()
        if (err) {
            return console.error(
                'Error executing query', err.stack)
        }
        console.log("Connected to Database !")
    })
})

app.use(function (req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);
    next();
});

app.use(function(req, res, next) {
    res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    next();
});

const all_user_notification = require('./api/all_user_notification_function');
//(title, notification_message, notification_type, send_type, tbl_user_id, firebase_token)
// all_user_notification.send_notification_to_all_user('Review Meeting', 'Review Meeting will to appoint on monday at 11:00 PM.');
//all_user_notification.send_notification_to_user_by_firebase_token('Meeting approved new', 'Meeting is approved, Please check this meeting.',  'meeting', 'user', '14','e2F0kbb3R6Otk9mG4nhKuV:APA91bGIi852tFrgkzzK-QgmOVOwN7op-0c8MBWuhqO0sQUk32BhG1sNvPvMmHAax1Yh4kt4wLuIs6K_BHKlDv2K5Z9YiPoipjWDrt47Cx1BXOI5nFfhank');


app.get('/user_data',cors(), function(req, res) {
    console.log("Wealthyfy User data api live") ;
    res.status(200).json({ message: 'Wealthyfy User data api live'});
});

var user_dataAPI = require('./api/user_data');
app.post('/user_data/user_login_api', cors(), validation.user_login, user_dataAPI.user_login_api);
app.post('/user_data/my_profile_API', cors(), validation.tbl_user_id_validation, user_dataAPI.my_profile_API);
app.post('/user_data/my_team_API', cors(), validation.tbl_user_id_validation, user_dataAPI.my_team_API);
app.post('/user_data/upload_profile_image', cors(), user_dataAPI.upload_profile_image);
app.post('/user_data/user_team_designation_list_API', cors(), validation.tbl_user_id_validation, user_dataAPI.user_team_designation_list_API);

var meetingdataAPI = require('./api/meeting_data');
app.post('/meeting_data/create_meeting_api', cors(), validation.create_meeting, meetingdataAPI.create_meeting_api);
app.post('/meeting_data/edit_meeting_api', cors(), validation.edit_meeting, meetingdataAPI.edit_meeting_api);
app.post('/meeting_data/user_meeting_list_api', cors(), validation.tbl_user_id_validation, meetingdataAPI.user_meeting_list_api);
app.post('/meeting_data/meeting_reject_approved_api', cors(), validation.meeting_reject_approved, meetingdataAPI.meeting_reject_approved_api);
app.post('/meeting_data/user_meeting_details_api', cors(), validation.user_meeting_details, meetingdataAPI.user_meeting_details_api);
app.post('/meeting_data/user_dashboard_approved_meeting_api', cors(), validation.tbl_user_id_validation, meetingdataAPI.user_dashboard_approved_meeting_api);
app.post('/meeting_data/meeting_check_in_api', cors(), validation.meeting_check_in, meetingdataAPI.meeting_check_in_api);


var attendance_dataAPI = require('./api/attendance');
app.post('/attendance/user_check_in_API', cors(), validation.user_check_in, attendance_dataAPI.user_check_in_API);
app.post('/attendance/user_check_out_API', cors(), validation.user_check_out, attendance_dataAPI.user_check_out_API);
app.post('/attendance/user_attendance_list_API', cors(), validation.user_attendance_list, attendance_dataAPI.user_attendance_list_API);
app.post('/attendance/my_team_attendance_list_API', cors(), validation.user_attendance_list, attendance_dataAPI.my_team_attendance_list_API);
app.post('/attendance/my_team_attendance_detail_API', cors(), validation.user_attendance_detail, attendance_dataAPI.my_team_attendance_detail_API);
app.post('/attendance/yesterday_user_attendance_API', cors(), validation.tbl_user_id_validation, attendance_dataAPI.yesterday_user_attendance_API);
app.get('/attendance/leave_type_list_API', cors(), attendance_dataAPI.leave_type_list_API);
app.post('/attendance/user_leave_apply_API', cors(), validation.user_leave_apply,  attendance_dataAPI.user_leave_apply_API);
app.post('/attendance/user_leave_apply_list_API', cors(), validation.user_leave_list,  attendance_dataAPI.user_leave_apply_list_API);
app.post('/attendance/user_leave_apply_detail_API', cors(), validation.user_leave_detail,  attendance_dataAPI.user_leave_apply_detail_API);
app.post('/attendance/leave_reject_approved_API', cors(), validation.leave_reject_approved,  attendance_dataAPI.leave_reject_approved_API);

app.post('/attendance/user_full_attendance_list_API', cors(), validation.user_full_attendance_list, attendance_dataAPI.user_full_attendance_list_API);
app.post('/attendance/my_team_full_attendance_list_API', cors(), validation.my_team_full_attendance_list, attendance_dataAPI.my_team_full_attendance_list_API);

var admin_user_dataAPI = require('./api/admin_user_data');
app.post('/admin_user_data/create_user_by_admin_API', cors(), admin_user_dataAPI.create_user_by_admin_API);
app.post('/admin_user_data/update_user_details_API', cors(), admin_user_dataAPI.update_user_details_API);

var notificationdataAPI = require('./api/notification_data');
app.post('/notification_data/notification_list_API', cors(), validation.notification_list_API, notificationdataAPI.notification_list_API);


app.listen(port);
console.log('Listening on port ' + port);