const pg = require('pg');
const moment = require('moment');
const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);
const { haversineDistance } = require('./haversine');
const all_user_notification = require('./all_user_notification_function');
const moment_timezone = require('moment-timezone');

const base_img_url = 'http://wealthyfy.ojpasoftware.com:8112/files/upload';

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

module.exports = {

      user_check_in_API: async (request, response) => {
        
        const { tbl_user_id, tbl_office_id, check_in_latitude, check_in_longitude } = request.body;

        console.log('user_check_in_API', request.body);
        
        const currentTime = moment();
        ///// office late code start from here
            const officeLateTime = '08:45 AM';
            const lateThreshold = moment(officeLateTime, 'hh:mm A');
            lateThreshold.set({ year: moment().year(), month: moment().month(), date: moment().date() });
            // Compare current time with office late threshold
            const isLate = currentTime.isAfter(lateThreshold) ? 'late' : 'no';

            // console.log(`Current Time: ${currentTime.format('hh:mm A')}`);
            // console.log(`Office Late Time: ${lateThreshold.format('hh:mm A')}`);
            // console.log(`Status: ${isLate}`);
        ///// office late code end here

        ///// office early code start from here
            // Define early range times
                const officeEarlyTime = '07:00 AM';       // Start of early range
                const officeEarlyEndTime = '08:30 AM';    // End of early range

                // Parse times and set them to today's date
                const earlyStart = moment(officeEarlyTime, 'hh:mm A').set({year: moment().year(),month: moment().month(), date: moment().date() });

                const earlyEnd = moment(officeEarlyEndTime, 'hh:mm A').set({ year: moment().year(), month: moment().month(), date: moment().date() });

                // Check if current time falls in early range
                const isEarly = currentTime.isBetween(earlyStart, earlyEnd, null, '[]') ? 'early' : 'no';

                // console.log(`Current Time: ${currentTime.format('hh:mm A')}`);
                // console.log(`Early Range: ${earlyStart.format('hh:mm A')} - ${earlyEnd.format('hh:mm A')}`);
                // console.log(`Status: ${isEarly}`);
            ///// office early code end here

        try {
            // Execute all required queries in parallel to save time
            const [userQueryResult, officeQueryResult, alreadyCheckedInResult] = await Promise.all([
                pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]),
                pool.query( `SELECT tbl_office_id, office_latitude, office_longitude FROM tbl_office WHERE tbl_office_id = $1`, [tbl_office_id] ),
                pool.query( `SELECT check_in_time FROM tbl_attendance  WHERE tbl_user_id = $1 AND tbl_office_id = $2 AND DATE(check_in_time) = CURRENT_DATE`, [tbl_user_id, tbl_office_id]),
            ]);
    
            // Check if user exists
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.' });
            }
    
            // Check if office exists
            if (officeQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'Office not found.' });
            }
    
            // Check if the user has already checked in
            if (alreadyCheckedInResult.rowCount > 0) {
                return response.status(201).json({ status: false, message: 'You have already checked in today.' });
            }
    
            const office_latitude = parseFloat(officeQueryResult.rows[0].office_latitude);
            const office_longitude = parseFloat(officeQueryResult.rows[0].office_longitude);
    
            // Calculate the distance
            const distance = haversineDistance(
                parseFloat(check_in_latitude),
                parseFloat(check_in_longitude),
                office_latitude,
                office_longitude
            );
    
            console.log('distance', distance);
    
            // Check if within 100 meters
            if (distance > 200) {

                const updt_tbl_user_query = await pool.query(`UPDATE tbl_user SET check_in_status = 'denied', check_in_latitude = '${check_in_latitude}', check_in_longitude = '${check_in_longitude}', check_in_distance = '${distance}' WHERE tbl_user_id = '${tbl_user_id}'`);

                return response.status(201).json({ status: false, message: 'Check-in denied. You are not within 200 meters of the office.', });
            }

            // Insert check-in record
            const checkInResult = await pool.query(`INSERT INTO tbl_attendance (tbl_user_id, tbl_office_id, check_in_time, check_in_latitude, check_in_longitude, is_late, is_early)  VALUES ($1, $2, CURRENT_TIMESTAMP, $3, $4, $5, $6)`,[tbl_user_id, tbl_office_id, check_in_latitude, check_in_longitude, isLate, isEarly]);
    
            if (checkInResult.rowCount > 0) {
                

                const updt_tbl_user_query = await pool.query(`UPDATE tbl_user SET check_in_status = 'success', check_in_latitude = '${check_in_latitude}', check_in_longitude = '${check_in_longitude}', check_in_distance = '${distance}' WHERE tbl_user_id = '${tbl_user_id}'`);
                return response.status(201).json({ status: true, message: 'Check-in successful' });
            } else {
                return response.status(201).json({ status: false, message: 'Failed to update check-in.' });
            }
        } catch (error) {
            console.error('Error during check-in:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.' });
        }
    },

    // this code is commnet to check early/late condition ////

    // user_check_in_API: async (request, response) => {
        
    //     const { tbl_user_id, tbl_office_id, check_in_latitude, check_in_longitude } = request.body;

    //     console.log('user_check_in_API', request.body);
        
    //     const currentTime = moment();
    //     ///// office late code start from here
    //         const officeLateTime = '08:45 AM';
    //         const lateThreshold = moment(officeLateTime, 'hh:mm A');
    //         lateThreshold.set({ year: moment().year(), month: moment().month(), date: moment().date() });
    //         // Compare current time with office late threshold
    //         const isLate = currentTime.isAfter(lateThreshold) ? 'late' : 'no';

    //         // console.log(`Current Time: ${currentTime.format('hh:mm A')}`);
    //         // console.log(`Office Late Time: ${lateThreshold.format('hh:mm A')}`);
    //         // console.log(`Status: ${isLate}`);
    //     ///// office late code end here

    //     ///// office early code start from here
    //         // Define early range times
    //             const officeEarlyTime = '07:00 AM';       // Start of early range
    //             const officeEarlyEndTime = '08:30 AM';    // End of early range

    //             // Parse times and set them to today's date
    //             const earlyStart = moment(officeEarlyTime, 'hh:mm A').set({year: moment().year(),month: moment().month(), date: moment().date() });

    //             const earlyEnd = moment(officeEarlyEndTime, 'hh:mm A').set({ year: moment().year(), month: moment().month(), date: moment().date() });

    //             // Check if current time falls in early range
    //             const isEarly = currentTime.isBetween(earlyStart, earlyEnd, null, '[]') ? 'early' : 'no';

    //             // console.log(`Current Time: ${currentTime.format('hh:mm A')}`);
    //             // console.log(`Early Range: ${earlyStart.format('hh:mm A')} - ${earlyEnd.format('hh:mm A')}`);
    //             // console.log(`Status: ${isEarly}`);
    //         ///// office early code end here

    //     try {
    //         // Execute all required queries in parallel to save time
    //         const [userQueryResult, officeQueryResult, alreadyCheckedInResult] = await Promise.all([
    //             pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]),
    //             pool.query( `SELECT tbl_office_id, office_latitude, office_longitude FROM tbl_office WHERE tbl_office_id = $1`, [tbl_office_id] ),
    //             pool.query( `SELECT check_in_time FROM tbl_attendance  WHERE tbl_user_id = $1 AND tbl_office_id = $2 AND DATE(check_in_time) = CURRENT_DATE`, [tbl_user_id, tbl_office_id]),
    //         ]);
    
    //         // Check if user exists
    //         if (userQueryResult.rowCount === 0) {
    //             return response.status(201).json({ status: false, message: 'User not found.' });
    //         }
    
    //         // Check if office exists
    //         if (officeQueryResult.rowCount === 0) {
    //             return response.status(201).json({ status: false, message: 'Office not found.' });
    //         }
    
    //         // Check if the user has already checked in
    //         if (alreadyCheckedInResult.rowCount > 0) {
    //             return response.status(201).json({ status: false, message: 'You have already checked in today.' });
    //         }
    
    //         const office_latitude = parseFloat(officeQueryResult.rows[0].office_latitude);
    //         const office_longitude = parseFloat(officeQueryResult.rows[0].office_longitude);
    
    //         // Calculate the distance
    //         const distance = haversineDistance(
    //             parseFloat(check_in_latitude),
    //             parseFloat(check_in_longitude),
    //             office_latitude,
    //             office_longitude
    //         );
    
    //         console.log('distance', distance);
    
    //         // Check if within 100 meters
    //         if (distance > 200) {
    //             return response.status(201).json({ status: false, message: 'Check-in denied. You are not within 200 meters of the office.', });
    //         }

    //         // Insert check-in record
    //         const checkInResult = await pool.query( `INSERT INTO tbl_attendance (tbl_user_id, tbl_office_id, check_in_time, check_in_latitude, check_in_longitude, is_late, is_early)  VALUES ($1, $2, CURRENT_TIMESTAMP, $3, $4, $5, $6)`,[tbl_user_id, tbl_office_id, check_in_latitude, check_in_longitude, isLate, isEarly]);
    
    //         if (checkInResult.rowCount > 0) {
    //             return response.status(201).json({ status: true, message: 'Check-in successful' });
    //         } else {
    //             return response.status(201).json({ status: false, message: 'Failed to update check-in.' });
    //         }
    //     } catch (error) {
    //         console.error('Error during check-in:', error);
    //         return response.status(201).json({ status: false, message: 'Server error occurred.' });
    //     }
    // },

    

    

    //////////////// this api is created for update  early/late attendence on 12-05-2025 ////////////////
    
    //  update_user_attendence_late_early_api: async (request, response) => {
    //     const { tbl_user_id } = request.body;

    //     if (!tbl_user_id) {
    //         return response.status(400).json({ status: false, message: 'tbl_user_id is required.' });
    //     }

    //     try {
    //         // Get all attendance records for the user
    //         // const attendanceRes = await pool.query(`
    //         //     SELECT * FROM tbl_attendance 
    //         //     WHERE tbl_user_id = $1
    //         // `, [tbl_user_id]);
    //         const attendanceRes = await pool.query(`
    //             SELECT * FROM tbl_attendance`, []);

    //         // if (attendanceRes.rowCount === 0) {
    //         //     return response.status(404).json({ status: false, message: 'No attendance records found.' });
    //         // }

    //         for (const attendance of attendanceRes.rows) {
    //             const checkInTime = moment(attendance.check_in_time);

    //             // Office Late Time
    //             const officeLateTime = '08:45';
    //             const [lateHour, lateMinute] = officeLateTime.split(':').map(Number);
    //             const lateThreshold = moment(checkInTime).startOf('day').hour(lateHour).minute(lateMinute);
    //             const isLate = checkInTime.isAfter(lateThreshold) ? 'late' : 'no';

    //             // Office Early Time Range
    //             const officeEarlyTime = '07:00';
    //             const officeEarlyEndTime = '08:15';
    //             const [earlyHour, earlyMinute] = officeEarlyTime.split(':').map(Number);
    //             const [earlyEndHour, earlyEndMinute] = officeEarlyEndTime.split(':').map(Number);
    //             const earlyStart = moment(checkInTime).startOf('day').hour(earlyHour).minute(earlyMinute);
    //             const earlyEnd = moment(checkInTime).startOf('day').hour(earlyEndHour).minute(earlyEndMinute);
    //             const isEarly = checkInTime.isBetween(earlyStart, earlyEnd, null, '[)') ? 'early' : 'no';

    //             // Update the current attendance record
    //             await pool.query(`
    //                 UPDATE tbl_attendance 
    //                 SET is_early = $1, is_late = $2 
    //                 WHERE tbl_attendance_id = $3
    //             `, [isEarly, isLate, attendance.tbl_attendance_id]);
    //         }

    //         return response.status(200).json({
    //             status: true,
    //             message: 'All attendance records updated with late/early status.',
    //             total_updated: attendanceRes.rowCount
    //         });

    //     } catch (error) {
    //         console.error('Error in update_user_attendence_late_early_api:', error);
    //         return response.status(500).json({ status: false, message: 'Server error.' });
    //     }
    // },



    user_check_out_API: async (request, response) => {
        const { tbl_user_id, tbl_office_id, check_out_latitude, check_out_longitude } = request.body;

        console.log('user_check_out_API', request.body);
    
        try {
            // Execute required queries in parallel
            const [userQueryResult, officeQueryResult, checkInResult] = await Promise.all([
                pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]),
                pool.query(`SELECT tbl_office_id FROM tbl_office WHERE tbl_office_id = $1`, [tbl_office_id]),
                pool.query(`SELECT tbl_attendance_id, check_in_time, check_out_time  FROM tbl_attendance WHERE tbl_user_id = $1 AND tbl_office_id = $2 AND DATE(check_in_time) = CURRENT_DATE LIMIT 1`, [tbl_user_id, tbl_office_id]),
            ]);
    
            // Check if the user exists
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.' });
            }
    
            // Check if the office exists
            if (officeQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'Office not found.' });
            }
    
            // Check if there is a check-in record for today
            if (checkInResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'No check-in record found for today.' });
            }
    
            // Check if the user has already checked out
            const checkOutTime = checkInResult.rows[0].check_out_time;
            if (checkOutTime) {
                return response.status(201).json({ status: false, message: 'You have already checked out today.' });
            }
    
            // Update the attendance record with check-out details
            const attendanceId = checkInResult.rows[0].tbl_attendance_id;
            const checkOutResult = await pool.query(
                `UPDATE tbl_attendance  SET check_out_time = CURRENT_TIMESTAMP,  check_out_latitude = $1,  check_out_longitude = $2 WHERE tbl_attendance_id = $3`, [check_out_latitude, check_out_longitude, attendanceId] 
            );
    
            if (checkOutResult.rowCount > 0) {
                return response.status(200).json({ status: true, message: 'Check-out successful' });
            } else {
                return response.status(201).json({ status: false, message: 'Failed to update check-out.' });
            }
        } catch (error) {
            console.error('Error during check-out:', error);
            return response.status(500).json({ status: false, message: 'Server error occurred.' });
        }
    },
    
    user_attendance_list_API : async (request, response) => {

        const { tbl_user_id, from_date, to_date } = request.body;        

        if (from_date == undefined || from_date == null || from_date == '')
        {
            var from_date1 = ``;
        }else{
            var from_date1 = `AND created_date >= '${from_date}'`;
        }
    
        if (to_date == undefined || to_date == null || to_date == '') 
        {
            var to_date1 = ``;
        }else{
            var to_date1 = `AND created_date <= '${to_date}'`;
        }

        // data_format is 2024-11-22;
    
        try {
            // Validate the user ID
            const userQueryResult = await pool.query( `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'` );
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.', });
            }
            // Fetch attendance records
            const attendanceResult = await pool.query(`
                SELECT * FROM tbl_attendance WHERE tbl_user_id = '${tbl_user_id}'  ${from_date1} ${to_date1} ORDER BY tbl_attendance_id DESC
            `);
    
            if (attendanceResult.rowCount > 0) {
                const attendanceData = attendanceResult.rows.map((table) => {
                    // Parse check-in and check-out times
                  
                    
                    const checkInTime = moment(table.check_in_time);
                    const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

                    // Calculate working time
                    const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';
    
                    return {
                        tbl_attendance_id: table.tbl_attendance_id,
                        tbl_user_id: table.tbl_user_id,
                        tbl_office_id: table.tbl_office_id,
                        day_number: moment(table.created_date).format('DD'),
                        day_name: moment(table.created_date).format('ddd'),
                        created_date: moment(table.created_date).format('DD ddd, MMM, YYYY'),
                        check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                        check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                        working_time: workingTime,
                        // check_in_latitude: isNull(table.check_in_latitude),
                        // check_in_longitude: isNull(table.check_in_longitude),
                        // check_out_latitude: isNull(table.check_out_latitude),
                        // check_out_longitude: isNull(table.check_out_longitude),
                    };
                });
    
                return response.status(200).json({  status: true, message: 'Attendance list retrieved successfully.', data: attendanceData,});
            } else {
                return response.status(201).json({status: false, message: 'No attendance records found.', data: [], });
            }
        } catch (error) {
            console.error('Error fetching attendance list:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },

    // user_full_attendance_list_API: async (request, response) => {

    //     const { tbl_user_id, from_date, to_date, status } = request.body;
       
    
    //     // if (!tbl_user_id || !from_date || !to_date) {
    //     //     return response.status(400).json({status: false, message: 'tbl_user_id, from_date, and to_date are required.'});
    //     // }
    
    //     const today = moment().format('YYYY-MM-DD');
    //     const safeToDate = moment(to_date).isAfter(today) ? today : to_date;
    
    //     try {
    //         // Validate user
    //         const userQueryResult = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]);
    //         if (userQueryResult.rowCount === 0) {
    //             return response.status(404).json({ status: false, message: 'User not found.' });
    //         }
    
    //         // Fetch attendance
    //         const attendanceResult = await pool.query(
    //             `SELECT * FROM tbl_attendance WHERE tbl_user_id = $1 AND created_date BETWEEN $2 AND $3`,
    //             [tbl_user_id, from_date, safeToDate]
    //         );
    
    //         // Map of present dates
    //         const presentDatesMap = {};
    //         attendanceResult.rows.forEach(row => {
    //             const dateStr = moment(row.created_date).format('YYYY-MM-DD');
    //             presentDatesMap[dateStr] = row;
    //         });
    
    //         // Fetch leave records and build leave date map
    //         const leaveResult = await pool.query(
    //             `SELECT from_date, to_date FROM tbl_user_leave WHERE tbl_user_id = $1 AND from_date <= $2 AND to_date >= $3`,
    //             [tbl_user_id, safeToDate, from_date]
    //         );
    
    //         const leaveDatesSet = new Set();
    //         leaveResult.rows.forEach(leave => {
    //             const start = moment(leave.from_date);
    //             const end = moment(leave.to_date);
    //             for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
    //                 leaveDatesSet.add(m.format('YYYY-MM-DD'));
    //             }
    //         });
    
    //         // Generate attendance list
    //         const start = moment(from_date);
    //         const end = moment(safeToDate);
    //         const fullAttendanceList = [];
    
    //         for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
    //             const currentDateStr = m.format('YYYY-MM-DD');
    //             const dayOfWeek = m.day();
    //             const presentRow = presentDatesMap[currentDateStr];
    //             let isLate = 'no';
    //             let isEarly = 'no';
    //             if (presentRow) {
    //                 const checkInTime = moment(presentRow.check_in_time);
    //                 const checkOutTime = presentRow.check_out_time ? moment(presentRow.check_out_time) : null;
    //                 const workingTime = checkOutTime
    //                     ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
    //                     : 'N/A';

    //                     ///// office late code start from here
    //                         const officeLateTime = '08:45'; //officeTimeResult.rows[0].late_time; // Expecting something like '08:45'
    //                         const [lateHour, lateMinute] = officeLateTime.split(':').map(Number);
    //                         // Compare check-in against dynamic office late time
    //                         const lateThreshold = moment(checkInTime).startOf('day').hour(lateHour).minute(lateMinute);
    //                         isLate = checkInTime.isAfter(lateThreshold) ? 'late' : 'no';
    //                     ///// office late code end here

    //                     ///// office early code start from here
    //                         const officeEarlyTime = '07:00';        // Start of early range
    //                         const officeEarlyEndTime = '08:20';     // End of early range
                            
    //                         const [earlyHour, earlyMinute] = officeEarlyTime.split(':').map(Number);
    //                         const [earlyEndHour, earlyEndMinute] = officeEarlyEndTime.split(':').map(Number);
                            
    //                         // Create Moment.js time ranges
    //                         const earlyStart = moment(checkInTime).startOf('day').hour(earlyHour).minute(earlyMinute);
    //                         const earlyEnd = moment(checkInTime).startOf('day').hour(earlyEndHour).minute(earlyEndMinute);
                            
    //                         // Check if current check-in is early
    //                         isEarly = checkInTime.isBetween(earlyStart, earlyEnd, null, '[)') ? 'early' : 'no';

    //                        // console.log('isEarly', isEarly);
    //                     ///// office early code end here

    //                     // if(isLate == 'yes'){
    //                     //    var isStatus = 'late';
    //                     // }else  if(isEarly == 'yes'){
    //                     //    var isStatus = 'early';
    //                     // }else{
    //                     //     var isStatus = 'present';
    //                     // }
    
    //                 fullAttendanceList.push({
    //                     tbl_attendance_id: presentRow.tbl_attendance_id,
    //                     tbl_user_id: presentRow.tbl_user_id,
    //                     tbl_office_id: presentRow.tbl_office_id,
    //                     day_number: m.format('DD'),
    //                     day_name: m.format('ddd'),
    //                     created_date: m.format('DD ddd, MMM, YYYY'),
    //                     check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
    //                     check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
    //                     working_time: workingTime,
    //                     isLate: isLate,
    //                     isEarly: isEarly,
    //                     status:  'present'
    //                 });
    
    //             } else if (leaveDatesSet.has(currentDateStr)) {
    //                 fullAttendanceList.push({
    //                     tbl_attendance_id: 0,
    //                     tbl_user_id,
    //                     tbl_office_id: 0,
    //                     day_number: m.format('DD'),
    //                     day_name: m.format('ddd'),
    //                     created_date: m.format('DD ddd, MMM, YYYY'),
    //                     check_in_time: 'N/A',
    //                     check_out_time: 'N/A',
    //                     working_time: 'N/A',
    //                     isLate: isLate,
    //                     isEarly: isEarly,
    //                     status: 'leave'
    //                 });
    //             } else {
    //                 const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
    //                 fullAttendanceList.push({
    //                     tbl_attendance_id: 0,
    //                     tbl_user_id,
    //                     tbl_office_id: 0,
    //                     day_number: m.format('DD'),
    //                     day_name: m.format('ddd'),
    //                     created_date: m.format('DD ddd, MMM, YYYY'),
    //                     check_in_time: 'N/A',
    //                     check_out_time: 'N/A',
    //                     working_time: 'N/A',
    //                     isLate: isLate,
    //                     isEarly: isEarly,
    //                     status: isWeekend ? 'off' : 'absent'
    //                 });
    //             }
    //         }
    
    //         const filteredList = status ? fullAttendanceList.filter(item => item.status === status) : fullAttendanceList;
    
    //         // return response.status(200).json({ status: true, message: `Attendance list${status ? ` (filtered by ${status})` : ''} retrieved successfully.`, data: filteredList,
    //         // });

    //         if(filteredList.length > 0){
    //             return response.status(200).json({ 
    //                 status: true, 
    //                 message: `Attendance list${status ? ` (filtered by ${status})` : ''} retrieved successfully.`, 
    //                 data: filteredList,
    //             });
    //         } else {
    //             return response.status(201).json({
    //                 status: false, 
    //                 message: 'No attendance records found.',
    //                 data: [], 
    //             });
    //         }
    
    //     } catch (error) {
    //         console.error('Error fetching attendance list:', error);
    //         return response.status(500).json({
    //             status: false,
    //             message: 'Server error occurred.',
    //         });
    //     }
    // },
    
    user_full_attendance_list_API: async (request, response) => {

        const { tbl_user_id, from_date, to_date, status } = request.body;
    
        // if (!tbl_user_id || !from_date || !to_date) {
        //     return response.status(400).json({status: false, message: 'tbl_user_id, from_date, and to_date are required.'});
        // }
    
        const today = moment().format('YYYY-MM-DD');
        const safeToDate = moment(to_date).isAfter(today) ? today : to_date;
    
        try {
            // Validate user
            const userQueryResult = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]);
            if (userQueryResult.rowCount === 0) {
                return response.status(404).json({ status: false, message: 'User not found.' });
            }
    
            // Fetch attendance
            const attendanceResult = await pool.query(
                `SELECT * FROM tbl_attendance WHERE tbl_user_id = $1 AND created_date BETWEEN $2 AND $3`,
                [tbl_user_id, from_date, safeToDate]
            );
    
            // Map of present dates
            const presentDatesMap = {};
            attendanceResult.rows.forEach(row => {
                const dateStr = moment(row.created_date).format('YYYY-MM-DD');
                presentDatesMap[dateStr] = row;
            });
    
            // Fetch leave records and build leave date map
            const leaveResult = await pool.query(
                `SELECT from_date, to_date FROM tbl_user_leave WHERE tbl_user_id = $1 AND from_date <= $2 AND to_date >= $3`,
                [tbl_user_id, safeToDate, from_date]
            );
    
            const leaveDatesSet = new Set();
            leaveResult.rows.forEach(leave => {
                const start = moment(leave.from_date);
                const end = moment(leave.to_date);
                for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                    leaveDatesSet.add(m.format('YYYY-MM-DD'));
                }
            });
    
            // Generate attendance list
            const start = moment(from_date);
            const end = moment(safeToDate);
            const fullAttendanceList = [];
    
            for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                const currentDateStr = m.format('YYYY-MM-DD');
                const dayOfWeek = m.day();
                const presentRow = presentDatesMap[currentDateStr];
                let isLate = 'no';
                let isEarly = 'no';
                if (presentRow) {
                    const checkInTime = moment(presentRow.check_in_time);
                    const checkOutTime = presentRow.check_out_time ? moment(presentRow.check_out_time) : null;
                    const workingTime = checkOutTime
                        ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
                        : 'N/A';                        
    
                    fullAttendanceList.push({
                        tbl_attendance_id: presentRow.tbl_attendance_id,
                        tbl_user_id: presentRow.tbl_user_id,
                        tbl_office_id: presentRow.tbl_office_id,
                        day_number: m.format('DD'),
                        day_name: m.format('ddd'),
                        created_date: m.format('DD ddd, MMM, YYYY'),
                        check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                        check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                        working_time: workingTime,                        
                        isLate: presentRow.is_late,
                        isEarly: presentRow.is_early,
                        status:  'present'
                    });
    
                } else if (leaveDatesSet.has(currentDateStr)) {
                    fullAttendanceList.push({
                        tbl_attendance_id: 0,
                        tbl_user_id,
                        tbl_office_id: 0,
                        day_number: m.format('DD'),
                        day_name: m.format('ddd'),
                        created_date: m.format('DD ddd, MMM, YYYY'),
                        check_in_time: 'N/A',
                        check_out_time: 'N/A',
                        working_time: 'N/A',
                        isLate: isLate,
                        isEarly: isEarly,
                        status: 'leave'
                    });
                } else {
                    const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
                    fullAttendanceList.push({
                        tbl_attendance_id: 0,
                        tbl_user_id,
                        tbl_office_id: 0,
                        day_number: m.format('DD'),
                        day_name: m.format('ddd'),
                        created_date: m.format('DD ddd, MMM, YYYY'),
                        check_in_time: 'N/A',
                        check_out_time: 'N/A',
                        working_time: 'N/A',
                        isLate: isLate,
                        isEarly: isEarly,
                        status: isWeekend ? 'off' : 'absent'
                    });
                }
            }
    
            // const filteredList = status ? fullAttendanceList.filter(item => item.status === status): fullAttendanceList;

            /// this filter code is implemented on 12-05-2025

            let  filteredList = fullAttendanceList;
            if (status) {
                if (status === 'late') {
                    filteredList = fullAttendanceList.filter(item => item.status === 'present' && item.isLate === 'late');
                } else if(status === 'early') {
                    filteredList = fullAttendanceList.filter(item => item.status === 'present' && item.isEarly === 'early');
                } else {
                    filteredList = fullAttendanceList.filter(item => item.status === status);
                }
            }

            if(filteredList.length > 0){
                return response.status(200).json({ 
                    status: true, 
                    message: `Attendance list${status ? ` (filtered by ${status})` : ''} retrieved successfully.`, 
                    data: filteredList,
                });
            } else {
                return response.status(201).json({
                    status: false, 
                    message: 'No attendance records found.',
                    data: [], 
                });
            }
    
        } catch (error) {
            console.error('Error fetching attendance list:', error);
            return response.status(500).json({
                status: false,
                message: 'Server error occurred.',
            });
        }
    },


    yesterday_user_attendance_API : async (request, response) => {

        const { tbl_user_id } = request.body;

        // data_format is 2024-11-22;

        // const yesterday_date = moment().subtract(1, 'days').format('YYYY-MM-DD');
        const today_date = moment().format('YYYY-MM-DD');

       
        
        
        try {
            // Validate the user ID
            const userQueryResult = await pool.query( `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'` );
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.', });
            }
    
            // Fetch attendance records
            const attendanceResult = await pool.query(`SELECT * FROM tbl_attendance WHERE tbl_user_id = '${tbl_user_id}' AND created_date != '${today_date}' ORDER BY tbl_attendance_id DESC limit 1`);
    
            if (attendanceResult.rowCount > 0) {
                const attendanceData = attendanceResult.rows.map((table) => {
                    // Parse check-in and check-out times
                    const checkInTime = moment(table.check_in_time);
                    const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

                    // Calculate working time
                    const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';
    
                    return {
                        tbl_attendance_id: table.tbl_attendance_id,
                        tbl_user_id: table.tbl_user_id,
                        tbl_office_id: table.tbl_office_id,
                        day_number: moment(table.created_date).format('DD'),
                        day_name: moment(table.created_date).format('ddd'),
                        created_date: moment(table.created_date).format('DD ddd, MMM, YYYY'),
                        check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                        check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                        working_time: workingTime,
                    };
                });
    
                return response.status(200).json({  status: true, message: 'Dashboard Yesterday Attendance details.', data: attendanceData,});
            } else {
                return response.status(201).json({status: false, message: 'No attendance records found.', data: [], });
            }
        } catch (error) {
            console.error('Error fetching attendance list:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },

    leave_type_list_API: (request, response) => {


        

        const leavetypequery = `SELECT * FROM tbl_leave_type WHERE status = '1'`;

        pool.query(leavetypequery, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error });
            }

            if (result.rowCount > 0) {
                var res = result.rows;
                var data = [];

                res.forEach(function (table) {
                    let cat = {
                        tbl_leave_type_id: table.tbl_leave_type_id,
                        leave_type: isNull(table.leave_type)                       
                    };
                    data.push(cat);
                });
                return  response.status(201).json({ status: true, message: 'Leave type list API', data: data })

            } else {
                return response.status(201).json({ status: false, message: 'Leave type not found.', data: [] })
            }
        })
    }, 

    user_leave_apply_API: async (request, response) => {

        const { tbl_user_id, tbl_office_id, leave_type, from_date, to_date, reason } = request.body;

        //console.log('user_leave_apply_API', request.body);

        if(reason == null || reason == undefined || reason == '') {
            var insrt_reason = '';
        }else{
            var insrt_reason = reason;
        }

        try {
            // Execute all required queries in parallel to save time
            const [userQueryResult, officeQueryResult, alreadyCheckedInResult] = await Promise.all([
                pool.query(`SELECT tbl_user_id, full_name, designation_abbr FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'`),
                pool.query(`SELECT tbl_office_id FROM tbl_office WHERE tbl_office_id = '${tbl_office_id}'`),
                pool.query(`SELECT tbl_user_leave_id FROM tbl_user_leave  WHERE tbl_user_id = '${tbl_user_id}'  
                AND tbl_office_id = '${tbl_office_id}' AND status = 'pending'`),
            ]);
    
            // Check if user exists
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.' });
            }
    
            // Check if office exists
            if (officeQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'Office not found.' });
            }

            // Check if the user has already checked in
            if (alreadyCheckedInResult.rowCount > 0) {                              
                return response.status(201).json({ status: false, message: 'You request is already in pending.' });
            }
    
            // Insert check-in record
            const leav_apply_qury = await pool.query( `INSERT INTO tbl_user_leave(tbl_user_id, tbl_office_id, leave_type, from_date, to_date, reason)  VALUES('${tbl_user_id}', '${tbl_office_id}', '${leave_type}', '${from_date}', '${to_date}', $$${insrt_reason}$$) RETURNING tbl_user_leave_id`);
    
            if (leav_apply_qury.rowCount > 0) {

                //////////////////////// this code is integrate for notification of this user parent //////////

                // Recursive query to fetch all parent user IDs
                    const recursiveParentQuery = `
                        WITH RECURSIVE RecursiveCTE AS (
                           SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_user_id = $1
                           UNION ALL
                           SELECT t.tbl_user_id, t.tbl_parent_id 
                           FROM tbl_user_connection t 
                           INNER JOIN RecursiveCTE r ON r.tbl_parent_id = t.tbl_user_id
                        )
                        SELECT tbl_parent_id FROM RecursiveCTE;
                    `;

                    const ParentUserResult = await pool.query(recursiveParentQuery, [tbl_user_id]);                  
                    const parentIds = ParentUserResult.rows.map(row => row.tbl_parent_id);

                    const parentQuery = await pool.query(`SELECT tbl_user_id as parentid, firebase_tokens as parent_firebasetoken FROM tbl_user WHERE designation_abbr IN ('MD','VP','BM') AND tbl_user_id = ANY($1) ORDER BY tbl_user_id DESC`, [parentIds] );

                    if (parentQuery.rowCount > 0) {
                        const notificationPromises = parentQuery.rows.map(async (table) => {
                            const title = `New leave request`;
                            const notification_type = 'leave';
                            const notification_message = `New leave request is generated by ${userQueryResult.rows[0].full_name} (${userQueryResult.rows[0].designation_abbr})`;
                            const firebase_token = table.parent_firebasetoken;
                            const meeting_leave_id = leav_apply_qury.rows[0].tbl_user_leave_id;
                            const parent_id = table.parentid;
        
                            return all_user_notification.send_notification_to_user_by_firebase_token( title, notification_message, notification_type, 'user', tbl_user_id, firebase_token, meeting_leave_id, parent_id);
                        });
        
                        await Promise.all(notificationPromises);
                    } else {
                        console.log('Parent user not found for this user.');
                    }
                    
                //////////////////////// this code is integrate for notification of this user parent //////////

                return response.status(201).json({ status: true, message: 'Your request for leave submited succesfully.' });
            } else {
                return response.status(201).json({ status: false, message: 'Failed to apply leave.' });
            }
        } catch (error) {
            console.error('Error during check-in:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.' });
        }
    },

    noti_back_user_leave_apply_API: async (request, response) => {

        const { tbl_user_id, tbl_office_id, leave_type, from_date, to_date, reason } = request.body;

        

        if(reason == null || reason == undefined || reason == '') {
            var insrt_reason = '';
        }else{
            var insrt_reason = reason;
        }

        try {
            // Execute all required queries in parallel to save time
            const [userQueryResult, officeQueryResult, alreadyCheckedInResult] = await Promise.all([
                pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'`),
                pool.query(`SELECT tbl_office_id FROM tbl_office WHERE tbl_office_id = '${tbl_office_id}'`),
                pool.query(`SELECT tbl_user_leave_id FROM tbl_user_leave  WHERE tbl_user_id = '${tbl_user_id}'  
                AND tbl_office_id = '${tbl_office_id}' AND status = 'pending'`),
            ]);
    
            // Check if user exists
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.' });
            }
    
            // Check if office exists
            if (officeQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'Office not found.' });
            }

            // Check if the user has already checked in
            if (alreadyCheckedInResult.rowCount > 0) {
                return response.status(201).json({ status: false, message: 'You request is already in pending.' });
            }
    
            // Insert check-in record
            const leav_apply_qury = await pool.query( `INSERT INTO tbl_user_leave(tbl_user_id, tbl_office_id, leave_type, from_date, to_date, reason)  VALUES('${tbl_user_id}', '${tbl_office_id}', '${leave_type}', '${from_date}', '${to_date}', $$${insrt_reason}$$)`);
    
            if (leav_apply_qury.rowCount > 0) {


                return response.status(201).json({ status: true, message: 'Your request for leave submited succesfully.' });
            } else {
                return response.status(201).json({ status: false, message: 'Failed to apply leave.' });
            }
        } catch (error) {
            console.error('Error during check-in:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.' });
        }
    },

    user_leave_apply_list_API : async (request, response) => {

        const { tbl_user_id, type, status, designation_abbr, today, from_date, to_date, month_wise, year_wise } = request.body;

        // data_format is 2024-11-22;

        if (status == '' || status == null || status == undefined) {
            var status1 = ''
        } else {
            var status1 = `AND l.status = '${status}'`;
        }

        if (designation_abbr == '' || designation_abbr == null || designation_abbr == undefined) {
            var designation_abbr1 = ``
        } else {
            var designation_abbr1 = `AND u.designation_abbr = '${designation_abbr}'`;
        }

        if (from_date == undefined || from_date == null || from_date == '')
        {
            var from_date1 = ``;
        }else{
            var from_date1 = `AND l.created_date >= '${from_date}'`;
        }
    
        if (to_date == undefined || to_date == null || to_date == '') 
        {
            var to_date1 = ``;
        }else{
            var to_date1 = `AND l.created_date <= '${to_date}'`;
        }

        if (today == undefined || today == null || today == '') 
        {
            var today1 = ``;
        }else{
            var today1 = `AND l.created_date = '${today}'`;
        }
        
        if (month_wise == undefined || month_wise == null || month_wise == '') 
        {
            var month_wise1 = ``;
        }else{
            var month_wise1 = `AND EXTRACT(MONTH FROM l.created_date) =  '${month_wise}'`;
        }

        if (year_wise == undefined || year_wise == null || year_wise == '')
        {
            var year_wise1 = ``;
        }else{
            var year_wise1 = `AND EXTRACT(YEAR FROM l.created_date) =  '${year_wise}'`;
        }

        try {

            const userQuery = await pool.query(`SELECT tbl_user_id FROM tbl_user_connection WHERE tbl_user_id = $1 AND status = '1'`, [tbl_user_id]);
            // const userQuery = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1 AND status = '1'`, [tbl_user_id]);
            if (userQuery.rowCount > 0) {

                let userIds = [];

                if(type === 'my_leave'){
                    var resmsg = 'My Leave';
                    userIds  = [tbl_user_id]
                }else if(type === 'team_leave'){
                    var resmsg = 'Team Leave';

                    const recursivequery = `
                      WITH RECURSIVE RecursiveCTE AS (
                       SELECT tbl_user_id, tbl_parent_id FROM tbl_user_connection WHERE  tbl_parent_id = $1

                       UNION ALL

                       SELECT t.tbl_user_id, t.tbl_parent_id 
                       FROM tbl_user_connection t 
                       INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                      )
                      SELECT tbl_user_id FROM RecursiveCTE;
                    `;
                    const childUsersResult = await pool.query(recursivequery, [tbl_user_id]);
                    userIds = childUsersResult.rows.map(row => row.tbl_user_id);
                }else{
                    return response.status(400).json({ status: false, message: 'Invalid type. Use "my_leave" or "team_leave".' });
                }       
                

                // Fetch leaveResult records
                // const leaveResult = await pool.query(`
                //     SELECT l.* FROM tbl_user_leave l WHERE l.tbl_user_id = ANY($1) ${status1} ${from_date1} ${to_date1} ${today1} ${month_wise1} ${year_wise1} ORDER BY l.tbl_user_leave_id DESC`,
                //     [userIds]
                // );

                const leaveResult = await pool.query(`SELECT l.*, u.emp_id, u.full_name, u.designation_abbr FROM tbl_user_leave l INNER JOIN tbl_user u ON l.tbl_user_id = u.tbl_user_id  WHERE l.tbl_user_id = ANY($1) ${status1} ${designation_abbr1} ${from_date1} ${to_date1} ${today1} ${month_wise1} ${year_wise1} ORDER BY l.tbl_user_leave_id DESC`, [userIds]);

                if (leaveResult.rowCount > 0) {
                    const leavData = leaveResult.rows.map((table) => {

                        return {
                            tbl_user_leave_id: table.tbl_user_leave_id,
                            tbl_user_id: table.tbl_user_id,
                            emp_id: table.emp_id,
                            full_name: isNull(table.full_name),
                            designation_abbr: isNull(table.designation_abbr),
                            tbl_office_id: table.tbl_office_id,
                            leave_type: isNull(table.leave_type),
                            from_date: moment(table.from_date).format('DD, MMM, YYYY'),
                            to_date: moment(table.to_date).format('DD, MMM, YYYY'),
                            leave_apply_date: moment(table.leave_apply_date).utcOffset('+05:30').format('ddd, DD MMM, YYYY'),
                            leave_apply_time: moment(table.leave_apply_date).utcOffset('+05:30').format('h:mm:ss A'),
                            status: isNull(table.status),
                            reason: isNull(table.reason)
                        };
                    });
        
                    return response.status(200).json({  status: true, message: `${resmsg} apply list.`, data: leavData,});
                } else {
                    return response.status(201).json({  status: false, message: `No ${resmsg} records found.`, data: [], });
                }
            } else {
                // User not found or inactive
                return response.status(404).json({ status: false, message: 'User not found or inactive.' });
            }
        } catch (error) {
            console.error('Error fetching leave list:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },

    user_leave_apply_detail_API : async (request, response) => {

        const { tbl_user_id, tbl_user_leave_id } = request.body;

        // data_format is 2024-11-22;

        try {
            // Validate the user ID
            const userQueryResult = await pool.query( `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'` );
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.', });
            }
    
            // Fetch leaveResult records
            const leaveResult = await pool.query(`SELECT l.*, u.emp_id, u.full_name, u.designation_abbr FROM tbl_user_leave l INNER JOIN tbl_user u ON l.tbl_user_id = u.tbl_user_id WHERE l.tbl_user_leave_id = '${tbl_user_leave_id}'`);
            //const leaveResult = await pool.query(`SELECT * FROM tbl_user_leave WHERE tbl_user_leave_id = '${tbl_user_leave_id}'`);
    
            if (leaveResult.rowCount > 0) {
                const leavData = leaveResult.rows.map((table) => {

                    return {
                        tbl_user_leave_id: table.tbl_user_leave_id,
                        tbl_user_id: table.tbl_user_id,
                        emp_id: table.emp_id,
                        full_name: isNull(table.full_name),
                        designation_abbr: isNull(table.designation_abbr),
                        tbl_office_id: table.tbl_office_id,
                        leave_type: isNull(table.leave_type),
                        from_date: moment(table.from_date).format('DD, MMM, YYYY'),
                        to_date: moment(table.to_date).format('DD, MMM, YYYY'),
                        leave_apply_date: moment(table.leave_apply_date).utcOffset('+05:30').format('ddd, DD MMM, YYYY'),
                        leave_apply_time: moment(table.leave_apply_date).utcOffset('+05:30').format('h:mm:ss A'),
                        status: isNull(table.status),
                        reason: isNull(table.reason)
                    };
                });
    
                return response.status(200).json({  status: true, message: 'User leave apply detail.', data: leavData,});
            } else {
                return response.status(201).json({status: false, message: 'No User leave records found.', data: [], });
            }
        } catch (error) {
            console.error('Error fetching leave detail:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },

    leave_reject_approved_API: async (req, res) => {

        const { tbl_user_leave_id, tbl_user_id, tbl_office_id, status, leave_approved_reject_by_user_id, leave_approved_reject_by_user_type, leave_reject_reason } = req.body;

        if (leave_reject_reason == '' || leave_reject_reason == null || leave_reject_reason == undefined) {
            var reason1 = ''
        } else {
            var reason1 = leave_reject_reason;
        }

        const userQuery = await pool.query(`SELECT tbl_user_id, firebase_tokens as user_firebasetoken from tbl_user where tbl_user_id = '${tbl_user_id}' AND status = '1'`);

        if (userQuery.rowCount > 0) {

            const ckleavQuery = await pool.query(`SELECT (SELECT full_name from tbl_user where tbl_user_id = '${leave_approved_reject_by_user_id}' AND status = '1') AS head_user_fullname, tbl_user_id, tbl_user_leave_id, leave_type, status from tbl_user_leave where tbl_user_leave_id = '${tbl_user_leave_id}' AND tbl_user_id = '${tbl_user_id}'`);

            if (ckleavQuery.rowCount > 0) {

                if (ckleavQuery.rows[0].status == 'rejected' || ckleavQuery.rows[0].status == 'approved') {
                    return res.status(500).json({ status: false, message: `This leave is already ${ckleavQuery.rows[0].status}.`});

                } else {

                    /// update meeting details query

                    const updt_leav_query = `UPDATE tbl_user_leave SET status = '${status}', leave_approved_reject_by_user_id = '${leave_approved_reject_by_user_id}',   leave_approved_reject_by_user_type = $$${leave_approved_reject_by_user_type}$$, leave_approved_reject_date_time = now(), leave_rejected_reason = $$${reason1}$$ where tbl_user_leave_id = '${tbl_user_leave_id}' AND tbl_user_id = '${tbl_user_id}' AND tbl_office_id = '${tbl_office_id}'`;

                    try {

                        const leav_updtResult = await pool.query(updt_leav_query);
                        if (leav_updtResult.rowCount > 0) {

                            const title = `Leave is ${status}`;
                            const notification_type = 'leave'
                            const notification_message = `Your ${ckleavQuery.rows[0].leave_type} is ${status} by ${ckleavQuery.rows[0].head_user_fullname} (${leave_approved_reject_by_user_type})`;
                            const firebase_token = userQuery.rows[0].user_firebasetoken;
                            const meeting_leave_id = tbl_user_leave_id;
                            const tbl_userid = leave_approved_reject_by_user_id;
                            const parent_id = tbl_user_id;

                            all_user_notification.send_notification_to_user_by_firebase_token(title, notification_message, notification_type, 'user', tbl_userid, firebase_token, meeting_leave_id, parent_id);

                            return res.status(201).json({ status: true, message: `Leave ${status} successfully.` });
                        } else {
                            return res.status(500).json({ status: false, message: 'Failed to update leave.' });
                        }
                    } catch (err) {
                        console.error(err);
                        return res.status(500).json({ status: false, message: 'Error occurred while updating leave.' });
                    }
                }
            } else {
                return res.status(404).json({ status: false, message: 'tbl_user_leave_id is wrong of this user.' });
            }
        } else {
            return res.status(404).json({ status: false, message: 'User not found' });
        }
    },

    ///// new code start on 04-04-2025   //////////////////
    my_team_attendance_list_API : async (request, response) => {

        const { tbl_user_id, from_date, to_date } = request.body;        

        if (from_date == undefined || from_date == null || from_date == '')
        {
            var from_date1 = ``;
        }else{
            var from_date1 = `AND a.created_date >= '${from_date}'`;
        }
    
        if (to_date == undefined || to_date == null || to_date == '') 
        {
            var to_date1 = ``;
        }else{
            var to_date1 = `AND a.created_date <= '${to_date}'`;
        }

        // data_format is 2024-11-22;
    
        try {
            let userIds = [];
            // Validate the user ID
            const userQueryResult = await pool.query( `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'` );
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.', });
            }    

            // Recursive query to fetch all child user IDs
            const recursiveUserQuery = `
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id, tbl_parent_id 
                    FROM tbl_user_connection 
                    WHERE tbl_parent_id = $1

                    UNION ALL

                    SELECT t.tbl_user_id, t.tbl_parent_id
                    FROM tbl_user_connection t
                    INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `;

            const childUsersResult = await pool.query(recursiveUserQuery, [tbl_user_id]);
            userIds = childUsersResult.rows.map(row => row.tbl_user_id);

            // Fetch attendance record

            const attendanceResult = await pool.query(`
                SELECT u.emp_id, u.full_name, u.designation_abbr, a.* FROM tbl_attendance a INNER JOIN tbl_user u ON a.tbl_user_id = u.tbl_user_id WHERE a.tbl_user_id = ANY($1) ${from_date1} ${to_date1} ORDER BY a.tbl_attendance_id DESC`, [userIds]
            );
    
            if(attendanceResult.rowCount > 0) {
                const attendanceData = attendanceResult.rows.map((table) => {
                    // Parse check-in and check-out times
                    const checkInTime = moment(table.check_in_time);
                    const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

                    // Calculate working time
                    const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';
    
                    return {
                        tbl_attendance_id: table.tbl_attendance_id,
                        tbl_user_id: table.tbl_user_id,
                        emp_id: table.emp_id,
                        full_name: isNull(table.full_name),
                        designation_abbr: isNull(table.designation_abbr),
                        tbl_office_id: table.tbl_office_id,
                        day_number: moment(table.created_date).format('DD'),
                        day_name: moment(table.created_date).format('ddd'),
                        created_date: moment(table.created_date).format('DD ddd, MMM, YYYY'),
                        check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                        check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                        working_time: workingTime
                    };
                });
    
                return response.status(200).json({  status: true, message: 'My Team Attendance list retrieved successfully.', data: attendanceData,});
            } else {
                return response.status(201).json({status: false, message: 'No my team attendance records found.', data: [], });
            }
        } catch (error) {
            console.error('Error fetching my team attendance list:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },

    my_team_attendance_detail_API : async (request, response) => {

        const { tbl_user_id, tbl_attendance_id } = request.body;
    
        try {

            // Validate the user ID
            const userQueryResult = await pool.query( `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'` );
            if (userQueryResult.rowCount === 0) {
                return response.status(201).json({ status: false, message: 'User not found.', });
            }    
            // Fetch attendance record

            const attendanceResult = await pool.query(`
                SELECT u.emp_id, u.full_name, u.designation_abbr, a.* FROM tbl_attendance a INNER JOIN tbl_user u ON a.tbl_user_id = u.tbl_user_id WHERE a.tbl_attendance_id = $1`, [tbl_attendance_id]
            );
    
            if(attendanceResult.rowCount > 0) {
                const attendanceData = attendanceResult.rows.map((table) => {
                    // Parse check-in and check-out times
                    const checkInTime = moment(table.check_in_time);
                    const checkOutTime = table.check_out_time ? moment(table.check_out_time): null;

                    // Calculate working time
                    const workingTime = checkOutTime ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s` : 'N/A';
    
                    return {
                        tbl_attendance_id: table.tbl_attendance_id,
                        tbl_user_id: table.tbl_user_id,
                        emp_id: table.emp_id,
                        full_name: isNull(table.full_name),
                        designation_abbr: isNull(table.designation_abbr),
                        tbl_office_id: table.tbl_office_id,
                        day_number: moment(table.created_date).format('DD'),
                        day_name: moment(table.created_date).format('ddd'),
                        created_date: moment(table.created_date).format('DD ddd, MMM, YYYY'),
                        check_in_time: checkInTime.utcOffset('+05:30').format('h:mm:ss A'),
                        check_out_time: checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A',
                        working_time: workingTime
                    };
                });
    
                return response.status(200).json({  status: true, message: 'My Team Attendance detail retrieved successfully.', data: attendanceData,});
            } else {
                return response.status(201).json({status: false, message: 'No my team attendance records found.', data: [], });
            }
        } catch (error) {
            console.error('Error fetching my team attendance detail:', error);
            return response.status(201).json({ status: false, message: 'Server error occurred.', });
        }
    },


    // my_team_full_attendance_list_API: async (request, response) => {
    //     const { tbl_user_id, from_date, to_date, status, pagenumber = 1, pagesize = 10 } = request.body;
        
    //     console.log('my_team_full_attendance_list_API', request.body);
        
    
    //     // if (!tbl_user_id || !from_date || !to_date) {
    //     //     return response.status(400).json({
    //     //         status: false,
    //     //         message: 'tbl_user_id, from_date, and to_date are required.'
    //     //     });
    //     // }
    
    //     const today = moment().format('YYYY-MM-DD');
    //     const safeToDate = moment(to_date).isAfter(today) ? today : to_date;
    
    //     try {
    //         // Check parent user exists
    //         const userQueryResult = await pool.query(
    //             `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`,
    //             [tbl_user_id]
    //         );
    //         if (userQueryResult.rowCount === 0) {
    //             return response.status(404).json({
    //                 status: false,
    //                 message: 'User not found.'
    //             });
    //         }
    
    //         // Recursive query to fetch all team members
    //         const recursiveUserQuery = `
    //             WITH RECURSIVE RecursiveCTE AS (
    //                 SELECT tbl_user_id FROM tbl_user_connection WHERE tbl_parent_id = $1
    //                 UNION ALL
    //                 SELECT t.tbl_user_id FROM tbl_user_connection t
    //                 INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
    //             )
    //             SELECT tbl_user_id FROM RecursiveCTE;
    //         `;
    //         const teamResult = await pool.query(recursiveUserQuery, [tbl_user_id]);
    //         const teamUserIds = teamResult.rows.map(row => row.tbl_user_id);
    
    //         if (teamUserIds.length === 0) {
    //             return response.status(200).json({
    //                 status: false,
    //                 message: 'No team members found.',
    //                 data: []
    //             });
    //         }
    
    //         // Fetch attendance data
    //         const attendanceQuery = await pool.query(`
    //             SELECT * FROM tbl_attendance
    //             WHERE tbl_user_id = ANY($1) AND created_date BETWEEN $2 AND $3
    //         `, [teamUserIds, from_date, safeToDate]);
    
    //         const attendanceMap = {};
    //         attendanceQuery.rows.forEach(row => {
    //             const dateStr = moment(row.created_date).format('YYYY-MM-DD');
    //             if (!attendanceMap[row.tbl_user_id]) attendanceMap[row.tbl_user_id] = {};
    //             attendanceMap[row.tbl_user_id][dateStr] = row;
    //         });
    
    //         // Fetch leave data
    //         const leaveQuery = await pool.query(`
    //             SELECT * FROM tbl_user_leave
    //             WHERE tbl_user_id = ANY($1) AND from_date <= $2 AND to_date >= $3
    //         `, [teamUserIds, safeToDate, from_date]);
    
    //         const leaveMap = {};
    //         leaveQuery.rows.forEach(row => {
    //             const start = moment(row.from_date);
    //             const end = moment(row.to_date);
    //             for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
    //                 const dateStr = m.format('YYYY-MM-DD');
    //                 if (!leaveMap[row.tbl_user_id]) leaveMap[row.tbl_user_id] = {};
    //                 leaveMap[row.tbl_user_id][dateStr] = true;
    //             }
    //         });
    
    //         const fullAttendanceList = [];
    
    //         for (const userId of teamUserIds) {
    //             const userDetails = await pool.query(
    //                 `SELECT emp_id, full_name, designation_abbr, tbl_office_id FROM tbl_user WHERE tbl_user_id = $1`,
    //                 [userId]
    //             );
    //             const { emp_id, full_name, designation_abbr, tbl_office_id } = userDetails.rows[0];
    
    //             const start = moment(from_date);
    //             const end = moment(safeToDate);
    
    //             for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
    //                 const currentDateStr = m.format('YYYY-MM-DD');
    //                 const dayOfWeek = m.day(); // 0 = Sunday, 6 = Saturday
    //                 const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
    
    //                 let statusValue = 'absent';
    //                 let check_in_time = 'N/A';
    //                 let check_out_time = 'N/A';
    //                 let working_time = 'N/A';
    //                 let attendance_id = 0;
    //                 let office_id = 0;
    //                 let isLate = 'no';
    //                 let isEarly = 'no';
    
    //                 if (attendanceMap[userId] && attendanceMap[userId][currentDateStr]) {
    //                     const att = attendanceMap[userId][currentDateStr];
    //                     const checkInTime = moment(att.check_in_time);
    //                     const checkOutTime = att.check_out_time ? moment(att.check_out_time) : null;
    //                     working_time = checkOutTime
    //                         ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
    //                         : 'N/A';
    //                     check_in_time = checkInTime.utcOffset('+05:30').format('h:mm:ss A');
    //                     check_out_time = checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A';
    //                     statusValue = 'present';
    //                     attendance_id = att.tbl_attendance_id;
                        

    //                     ///// office late code start from here
    //                     const officeLateTime = '08:45'; //officeTimeResult.rows[0].late_time; // Expecting something like '08:45'
    //                     const [lateHour, lateMinute] = officeLateTime.split(':').map(Number);
    //                     // Compare check-in against dynamic office late time
    //                     const lateThreshold = moment(checkInTime).startOf('day').hour(lateHour).minute(lateMinute);
    //                     isLate = checkInTime.isAfter(lateThreshold) ? 'late' : 'no';
    //                    ///// office late code end here

    //                 ///// office early code start from here
    //                         const officeEarlyTime = '07:00';        // Start of early range
    //                         const officeEarlyEndTime = '08:20';     // End of early range
                            
    //                         const [earlyHour, earlyMinute] = officeEarlyTime.split(':').map(Number);
    //                         const [earlyEndHour, earlyEndMinute] = officeEarlyEndTime.split(':').map(Number);
                            
    //                         // Create Moment.js time ranges
    //                         const earlyStart = moment(checkInTime).startOf('day').hour(earlyHour).minute(earlyMinute);
    //                         const earlyEnd = moment(checkInTime).startOf('day').hour(earlyEndHour).minute(earlyEndMinute);
                            
    //                         // Check if current check-in is early
    //                         isEarly = checkInTime.isBetween(earlyStart, earlyEnd, null, '[)') ? 'early' : 'no';

    //                      //console.log('isEarly', isEarly);
    //                 ///// office early code end here

    //                 } else if (leaveMap[userId] && leaveMap[userId][currentDateStr]) {
    //                     statusValue = 'leave';
    //                 } else if (isWeekend) {
    //                     statusValue = 'off';
    //                 }
    
    //                 const record = {
    //                     tbl_attendance_id: attendance_id,
    //                     tbl_user_id: userId,
    //                     emp_id,
    //                     full_name,
    //                     designation_abbr,
    //                     tbl_office_id,
    //                     day_number: m.format('DD'),
    //                     day_name: m.format('ddd'),
    //                     created_date: m.format('DD ddd, MMM, YYYY'),
    //                     check_in_time,
    //                     check_out_time,
    //                     working_time,
    //                     isLate,
    //                     isEarly,
    //                     status: statusValue
    //                 };
    
    //                 if (!status || statusValue === status) {
    //                     fullAttendanceList.push(record);
    //                 }
    //             }
    //         }
    
    //         // Pagination
    //         const startIndex = (pagenumber - 1) * pagesize;
    //         const endIndex = startIndex + pagesize;
    //         const paginatedData = fullAttendanceList.slice(startIndex, endIndex);

            

    //         if(paginatedData.length > 0){

    //             return response.status(200).json({
    //                 status: true,
    //                 message: `My team full attendance list${status ? ` filtered by ${status}` : ''} retrieved successfully.`,
    //                 total_records: fullAttendanceList.length,
    //                 pagenumber: pagenumber,
    //                 total_pages: Math.ceil(fullAttendanceList.length / pagesize),
    //                 data: paginatedData
    //             });
    //         } else {
    //             return response.status(201).json({
    //                 status: false, 
    //                 message: 'No my team attendance records found.', 
    //                 total_records: fullAttendanceList.length,
    //                 pagenumber: pagenumber,
    //                 total_pages: Math.ceil(fullAttendanceList.length / pagesize), 
    //                 data: []
    //             });
    //         }
    
    //     } catch (error) {
    //         console.error('Error in my_team_full_attendance_list_API:', error);
    //         return response.status(500).json({
    //             status: false,
    //             message: 'Server error occurred.'
    //         });
    //     }
    // },
    

    
    my_team_full_attendance_list_API: async (request, response) => {
        const { tbl_user_id, from_date, to_date, status, pagenumber = 1, pagesize = 10 } = request.body;
        
        console.log('my_team_full_attendance_list_API', request.body);
        
    
        // if (!tbl_user_id || !from_date || !to_date) {
        //     return response.status(400).json({
        //         status: false,
        //         message: 'tbl_user_id, from_date, and to_date are required.'
        //     });
        // }
    
        const today = moment().format('YYYY-MM-DD');
        const safeToDate = moment(to_date).isAfter(today) ? today : to_date;
    
        try {
            // Check parent user exists
            const userQueryResult = await pool.query(
                `SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`,
                [tbl_user_id]
            );
            if (userQueryResult.rowCount === 0) {
                return response.status(404).json({
                    status: false,
                    message: 'User not found.'
                });
            }
    
            // Recursive query to fetch all team members
            const recursiveUserQuery = `
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id FROM tbl_user_connection t
                    INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `;
            const teamResult = await pool.query(recursiveUserQuery, [tbl_user_id]);
            const teamUserIds = teamResult.rows.map(row => row.tbl_user_id);
    
            if (teamUserIds.length === 0) {
                return response.status(200).json({
                    status: false,
                    message: 'No team members found.',
                    data: []
                });
            }
    
            // Fetch attendance data
            const attendanceQuery = await pool.query(`
                SELECT * FROM tbl_attendance
                WHERE tbl_user_id = ANY($1) AND created_date BETWEEN $2 AND $3
            `, [teamUserIds, from_date, safeToDate]);
    
            const attendanceMap = {};
            attendanceQuery.rows.forEach(row => {
                const dateStr = moment(row.created_date).format('YYYY-MM-DD');
                if (!attendanceMap[row.tbl_user_id]) attendanceMap[row.tbl_user_id] = {};
                attendanceMap[row.tbl_user_id][dateStr] = row;
            });
    
            // Fetch leave data
            const leaveQuery = await pool.query(`
                SELECT * FROM tbl_user_leave
                WHERE tbl_user_id = ANY($1) AND from_date <= $2 AND to_date >= $3
            `, [teamUserIds, safeToDate, from_date]);
    
            const leaveMap = {};
            leaveQuery.rows.forEach(row => {
                const start = moment(row.from_date);
                const end = moment(row.to_date);
                for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                    const dateStr = m.format('YYYY-MM-DD');
                    if (!leaveMap[row.tbl_user_id]) leaveMap[row.tbl_user_id] = {};
                    leaveMap[row.tbl_user_id][dateStr] = true;
                }
            });
    
            const fullAttendanceList = [];
    
            for (const userId of teamUserIds) {
                const userDetails = await pool.query(
                    `SELECT emp_id, full_name, designation_abbr, tbl_office_id FROM tbl_user WHERE tbl_user_id = $1`,
                    [userId]
                );
                const { emp_id, full_name, designation_abbr, tbl_office_id, is_late, is_early } = userDetails.rows[0];
    
                const start = moment(from_date);
                const end = moment(safeToDate);
    
                for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                    const currentDateStr = m.format('YYYY-MM-DD');
                    const dayOfWeek = m.day(); // 0 = Sunday, 6 = Saturday
                    const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
    
                    let statusValue = 'absent';
                    let check_in_time = 'N/A';
                    let check_out_time = 'N/A';
                    let working_time = 'N/A';
                    let attendance_id = 0;
                    let office_id = 0;
                    let isLate = 'no';
                    let isEarly = 'no';
    
                    if (attendanceMap[userId] && attendanceMap[userId][currentDateStr]) {
                        const att = attendanceMap[userId][currentDateStr];
                        const checkInTime = moment(att.check_in_time);
                        const checkOutTime = att.check_out_time ? moment(att.check_out_time) : null;
                        working_time = checkOutTime
                            ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
                            : 'N/A';
                        check_in_time = checkInTime.utcOffset('+05:30').format('h:mm:ss A');
                        check_out_time = checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A';
                        statusValue = 'present';
                        attendance_id = att.tbl_attendance_id;
                        isLate = att.is_late;
                        isEarly = att.is_early;                        

                    } else if (leaveMap[userId] && leaveMap[userId][currentDateStr]) {
                        statusValue = 'leave';
                    } else if (isWeekend) {
                        statusValue = 'off';
                    }
                    
                    const record = {
                        tbl_attendance_id: attendance_id,
                        tbl_user_id: userId,
                        emp_id,
                        full_name,
                        designation_abbr,
                        tbl_office_id,
                        day_number: m.format('DD'),
                        day_name: m.format('ddd'),
                        created_date: m.format('DD ddd, MMM, YYYY'),
                        check_in_time,
                        check_out_time,
                        working_time,
                        isLate,
                        isEarly,
                        status: statusValue
                    };
                    
                    if (!status) {
                        fullAttendanceList.push(record);
                    } else if (status === 'late' && statusValue === 'present' && isLate === 'late') {
                        fullAttendanceList.push(record);
                    } else if (status === 'early' && statusValue === 'present' && isEarly === 'early') {
                        fullAttendanceList.push(record);
                    } else if (statusValue === status) {
                        fullAttendanceList.push(record);
                    }
                }
            }

            // Pagination
            const startIndex = (pagenumber - 1) * pagesize;
            const endIndex = startIndex + pagesize;
            const paginatedData = fullAttendanceList.slice(startIndex, endIndex);

            if(paginatedData.length > 0){

                return response.status(200).json({
                    status: true,
                    message: `My team full attendance list${status ? ` filtered by ${status}` : ''} retrieved successfully.`,
                    total_records: fullAttendanceList.length,
                    pagenumber: pagenumber,
                    total_pages: Math.ceil(fullAttendanceList.length / pagesize),
                    data: paginatedData
                });
            } else {
                return response.status(201).json({
                    status: false, 
                    message: 'No my team attendance records found.', 
                    total_records: fullAttendanceList.length,
                    pagenumber: pagenumber,
                    total_pages: Math.ceil(fullAttendanceList.length / pagesize), 
                    data: []
                });
            }
    
        } catch (error) {
            console.error('Error in my_team_full_attendance_list_API:', error);
            return response.status(500).json({
                status: false,
                message: 'Server error occurred.'
            });
        }
    },
    
    without_pagination_my_team_full_attendance_list_API : async (request, response) => {
        const { tbl_user_id, from_date, to_date, status } = request.body;
    
        if (!tbl_user_id || !from_date || !to_date) {
            return response.status(400).json({
                status: false,
                message: 'tbl_user_id, from_date, and to_date are required.'
            });
        }
    
        const today = moment().format('YYYY-MM-DD');
        const safeToDate = moment(to_date).isAfter(today) ? today : to_date;
    
        try {
            // Check parent user exists
            const userQueryResult = await pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]);
            if (userQueryResult.rowCount === 0) {
                return response.status(404).json({ status: false, message: 'User not found.' });
            }
    
            // Recursive query to fetch all team members
            const recursiveUserQuery = `
                WITH RECURSIVE RecursiveCTE AS (
                    SELECT tbl_user_id FROM tbl_user_connection WHERE tbl_parent_id = $1
                    UNION ALL
                    SELECT t.tbl_user_id FROM tbl_user_connection t
                    INNER JOIN RecursiveCTE r ON t.tbl_parent_id = r.tbl_user_id
                )
                SELECT tbl_user_id FROM RecursiveCTE;
            `;
            const teamResult = await pool.query(recursiveUserQuery, [tbl_user_id]);
            const teamUserIds = teamResult.rows.map(row => row.tbl_user_id);
    
            if (teamUserIds.length === 0) {
                return response.status(200).json({ status: false, message: 'No team members found.', data: [] });
            }
    
            // Fetch attendance data
            const attendanceQuery = await pool.query(`
                SELECT * FROM tbl_attendance
                WHERE tbl_user_id = ANY($1) AND created_date BETWEEN $2 AND $3
            `, [teamUserIds, from_date, safeToDate]);
    
            const attendanceMap = {};
            attendanceQuery.rows.forEach(row => {
                const dateStr = moment(row.created_date).format('YYYY-MM-DD');
                if (!attendanceMap[row.tbl_user_id]) attendanceMap[row.tbl_user_id] = {};
                attendanceMap[row.tbl_user_id][dateStr] = row;
            });
    
            // Fetch leave data
            const leaveQuery = await pool.query(`
                SELECT * FROM tbl_user_leave
                WHERE tbl_user_id = ANY($1) AND from_date <= $2 AND to_date >= $3
            `, [teamUserIds, safeToDate, from_date]);
    
            const leaveMap = {};
            leaveQuery.rows.forEach(row => {
                const start = moment(row.from_date);
                const end = moment(row.to_date);
                for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                    const dateStr = m.format('YYYY-MM-DD');
                    if (!leaveMap[row.tbl_user_id]) leaveMap[row.tbl_user_id] = {};
                    leaveMap[row.tbl_user_id][dateStr] = true;
                }
            });
    
            const fullAttendanceList = [];
    
            for (const userId of teamUserIds) {
                const userDetails = await pool.query(`SELECT emp_id, full_name, designation_abbr FROM tbl_user WHERE tbl_user_id = $1`, [userId]);
                const { emp_id, full_name, designation_abbr } = userDetails.rows[0];
    
                const start = moment(from_date);
                const end = moment(safeToDate);
    
                for (let m = moment(start); m.diff(end) <= 0; m.add(1, 'days')) {
                    const currentDateStr = m.format('YYYY-MM-DD');
                    const dayOfWeek = m.day(); // 0 = Sunday, 6 = Saturday
                    const isWeekend = dayOfWeek === 0 || dayOfWeek === 6;
    
                    let statusValue = 'absent';
                    let check_in_time = 'N/A';
                    let check_out_time = 'N/A';
                    let working_time = 'N/A';
                    let attendance_id = 0;
                    let office_id = 0;
    
                    if (attendanceMap[userId] && attendanceMap[userId][currentDateStr]) {
                        const att = attendanceMap[userId][currentDateStr];
                        const checkInTime = moment(att.check_in_time);
                        const checkOutTime = att.check_out_time ? moment(att.check_out_time) : null;
                        working_time = checkOutTime
                            ? `${checkOutTime.diff(checkInTime, 'hours')}h : ${checkOutTime.diff(checkInTime, 'minutes') % 60}m : ${checkOutTime.diff(checkInTime, 'seconds') % 60}s`
                            : 'N/A';
                        check_in_time = checkInTime.utcOffset('+05:30').format('h:mm:ss A');
                        check_out_time = checkOutTime ? checkOutTime.utcOffset('+05:30').format('h:mm:ss A') : 'N/A';
                        statusValue = 'present';
                        attendance_id = att.tbl_attendance_id;
                        office_id = att.tbl_office_id;
                    } else if (leaveMap[userId] && leaveMap[userId][currentDateStr]) {
                        statusValue = 'leave';
                    } else if (isWeekend) {
                        statusValue = 'off';
                    }
    
                    const record = {
                        tbl_attendance_id: attendance_id,
                        tbl_user_id: userId,
                        emp_id,
                        full_name,
                        designation_abbr,
                        tbl_office_id: office_id,
                        day_number: m.format('DD'),
                        day_name: m.format('ddd'),
                        created_date: m.format('DD ddd, MMM, YYYY'),
                        check_in_time,
                        check_out_time,
                        working_time,
                        status: statusValue
                    };
    
                    if (!status || statusValue === status) {
                        fullAttendanceList.push(record);
                    }
                }
            }
    
            return response.status(200).json({
                status: true,
                message: `My team full attendance list${status ? ` filtered by ${status}` : ''} retrieved successfully.`,
                data: fullAttendanceList
            });
    
        } catch (error) {
            console.error('Error in my_team_full_attendance_list_API:', error);
            return response.status(500).json({
                status: false,
                message: 'Server error occurred.'
            });
        }
    }
    


};