var {
    failure_callback,
    checkVar,
    isValidEmail
} = require('../middleware/common');


module.exports = {

    /////////////////////////////////////////////////////////// wealthyfy code end here ////////////////////////

    user_login: function (req, res, next) {

        try {
            const { email, password, firebase_tokens } = req.body

            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }

            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }

            if (checkVar(firebase_tokens)) {
                return failure_callback(res, ['firebase_tokens is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    notification_list_API: function (req, res, next) {

        try {
            const { tbl_user_id, pagesize, pagenumber } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(pagesize)) {
                return failure_callback(res, ['pagesize is required', 400])
            }
            if (checkVar(pagenumber)) {
                return failure_callback(res, ['pagenumber is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    tbl_user_id_validation: function (req, res, next) {
        try {
            const { tbl_user_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    user_attendance_list: function (req, res, next) {
        
        try {
            const { tbl_user_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
           
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    user_full_attendance_list: function (req, res, next) {
        
        try {
            const { tbl_user_id, from_date, to_date } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(from_date)) {
                return failure_callback(res, ['from_date is required', 400])
            }
            if (checkVar(to_date)) {
                return failure_callback(res, ['to_date is required', 400])
            }
           
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    my_team_full_attendance_list: function (req, res, next) {
        
        try {
            const { tbl_user_id, from_date, to_date, pagenumber, pagesize } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(from_date)) {
                return failure_callback(res, ['from_date is required', 400])
            }
            if (checkVar(to_date)) {
                return failure_callback(res, ['to_date is required', 400])
            }
            if (checkVar(pagenumber)) {
                return failure_callback(res, ['pagenumber is required', 400])
            }
            if (checkVar(pagesize)) {
                return failure_callback(res, ['pagesize is required', 400])
            }
           
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },
    
    user_attendance_detail: function (req, res, next) {
        
        try {
            const { tbl_user_id, tbl_attendance_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_attendance_id)) {
                return failure_callback(res, ['tbl_attendance_id is required', 400])
            }
           
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    user_check_in: function (req, res, next) {
        try {
            const { tbl_user_id, tbl_office_id, check_in_latitude, check_in_longitude } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(check_in_latitude)) {
                return failure_callback(res, ['check_in_latitude is required', 400])
            }
            if (checkVar(check_in_longitude)) {
                return failure_callback(res, ['check_in_longitude is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    user_check_out: function (req, res, next) {
        try {
            const { tbl_user_id, tbl_office_id, check_out_latitude, check_out_longitude } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(check_out_latitude)) {
                return failure_callback(res, ['check_out_latitude is required', 400])
            }
            if (checkVar(check_out_longitude)) {
                return failure_callback(res, ['check_out_longitude is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    user_leave_apply : function (req, res, next) {
        try {
            const { tbl_user_id, tbl_office_id, leave_type, from_date, to_date } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(leave_type)) {
                return failure_callback(res, ['leave_type is required', 400])
            }
            if (checkVar(from_date)) {
                return failure_callback(res, ['from_date is required', 400])
            }
            if (checkVar(to_date)) {
                return failure_callback(res, ['to_date is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    user_leave_list : function (req, res, next) {

        try {
            const { tbl_user_id, type } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(type)) {
                return failure_callback(res, ['type is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    // team_leave_apply_list : function (req, res, next) {

    //     try {
    //         const { tbl_user_id, type, month_wise } = req.body;

    //         if (checkVar(tbl_user_id)) {
    //             return failure_callback(res, ['tbl_user_id is required', 400])
    //         }
    //         if (checkVar(month_wise)) {
    //             return failure_callback(res, ['month_wise is required', 400])
    //         }
    //         if (checkVar(type)) {
    //             return failure_callback(res, ['type is required', 400])
    //         }
    //         return next();
    //     } catch (e) {
    //         return failure_callback(res, [e.message, 500]);
    //     }
    // },


    user_leave_detail : function (req, res, next) {

        try {
            const { tbl_user_id, tbl_user_leave_id } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_user_leave_id)) {
                return failure_callback(res, ['tbl_user_leave_id is required', 400])
            }
           
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    create_meeting : function (req, res, next) {

        try {
          

            const { tbl_office_id, tbl_user_id, client_id, client_name, client_email, client_mobile, city, state, country, meeting_latitude, meeting_longitude,  mutual_fund_portfolio, fixed_deposite, loan_details, insurance, full_address  } = req.body;

            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(client_id)) {
                return failure_callback(res, ['client_id is required', 400])
            }
            if (checkVar(client_name)) {
                return failure_callback(res, ['client_name is required', 400])
            }
            if (checkVar(client_email)) {
                return failure_callback(res, ['client_email is required', 400])
            }
            if (checkVar(client_mobile)) {
                return failure_callback(res, ['client_mobile is required', 400])
            }
            if (checkVar(city)) {
                return failure_callback(res, ['city is required', 400])
            }
            if (checkVar(state)) {
                return failure_callback(res, ['state is required', 400])
            }
            if (checkVar(country)) {
                return failure_callback(res, ['country is required', 400])
            }
            if (checkVar(meeting_latitude)) {
                return failure_callback(res, ['meeting_latitude is required', 400])
            }
            if (checkVar(meeting_longitude)) {
                return failure_callback(res, ['meeting_longitude is required', 400])
            }           
            if (checkVar(mutual_fund_portfolio)) {
                return failure_callback(res, ['mutual_fund_portfolio is required', 400])
            }
            if (checkVar(fixed_deposite)) {
                return failure_callback(res, ['fixed_deposite is required', 400])
            }
            if (checkVar(loan_details)) {
                return failure_callback(res, ['loan_details is required', 400])
            }
            if (checkVar(insurance)) {
                return failure_callback(res, ['insurance is required', 400])
            }            
            if (checkVar(full_address)) {
                return failure_callback(res, ['full_address is required', 400])
            }            
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    edit_meeting : function (req, res, next) {

        try {

            // const { tbl_meeting_id, tbl_user_id, client_id, client_name,  client_email, client_mobile, city, state, country, meeting_latitude, meeting_longitude, family_details, stock_portfolio_with_us, stock_portfolio_with_other_broker, mutual_fund_portfolio, fixed_deposite, loan_details, insurance, pms, ncd } = req.body;

            const { tbl_meeting_id, tbl_user_id, client_id, client_name, client_email, client_mobile, city, state, country, meeting_latitude, meeting_longitude,  mutual_fund_portfolio, fixed_deposite, loan_details, insurance, full_address } = req.body;

            if (checkVar(tbl_meeting_id)) {
                return failure_callback(res, ['tbl_meeting_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(client_id)) {
                return failure_callback(res, ['client_id is required', 400])
            }
            if (checkVar(client_name)) {
                return failure_callback(res, ['client_name is required', 400])
            }
            if (checkVar(client_email)) {
                return failure_callback(res, ['client_email is required', 400])
            }
            if (checkVar(client_mobile)) {
                return failure_callback(res, ['client_mobile is required', 400])
            }
            if (checkVar(city)) {
                return failure_callback(res, ['city is required', 400])
            }
            if (checkVar(state)) {
                return failure_callback(res, ['state is required', 400])
            }
            if (checkVar(country)) {
                return failure_callback(res, ['country is required', 400])
            }
            if (checkVar(meeting_latitude)) {
                return failure_callback(res, ['meeting_latitude is required', 400])
            }
            if (checkVar(meeting_longitude)) {
                return failure_callback(res, ['meeting_longitude is required', 400])
            }
           
            if (checkVar(mutual_fund_portfolio)) {
                return failure_callback(res, ['mutual_fund_portfolio is required', 400])
            }
            if (checkVar(fixed_deposite)) {
                return failure_callback(res, ['fixed_deposite is required', 400])
            }
            if (checkVar(loan_details)) {
                return failure_callback(res, ['loan_details is required', 400])
            }
            if (checkVar(insurance)) {
                return failure_callback(res, ['insurance is required', 400])
            }            
            if (checkVar(full_address)) {
                return failure_callback(res, ['full_address is required', 400])
            }            
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    user_meeting_details: function (req, res, next) {

        try {
            const { tbl_user_id, tbl_meeting_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }

            if (checkVar(tbl_meeting_id)) {
                return failure_callback(res, ['tbl_meeting_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    meeting_reject_approved: function (req, res, next) {

        try {
            const { tbl_user_id, tbl_meeting_id,  tbl_office_id, meeting_status, approved_reject_by_user_id, approved_reject_by_user_type } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }

            if (checkVar(tbl_meeting_id)) {
                return failure_callback(res, ['tbl_meeting_id is required', 400])
            }
            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(meeting_status)) {
                return failure_callback(res, ['meeting_status is required', 400])
            }
            if (checkVar(approved_reject_by_user_id)) {
                return failure_callback(res, ['approved_reject_by_user_id is required', 400])
            }
            if (checkVar(approved_reject_by_user_type)) {
                return failure_callback(res, ['approved_reject_by_user_type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    leave_reject_approved: function (req, res, next) {

        try {
            const { tbl_user_leave_id, tbl_user_id, tbl_office_id, status, leave_approved_reject_by_user_id, leave_approved_reject_by_user_type, leave_reject_reason } = req.body

            if (checkVar(tbl_user_leave_id)) {
                return failure_callback(res, ['tbl_user_leave_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(status)) {
                return failure_callback(res, ['status is required', 400])
            }
            
            if (checkVar(leave_approved_reject_by_user_id)) {
                return failure_callback(res, ['leave_approved_reject_by_user_id is required', 400])
            }
            if (checkVar(leave_approved_reject_by_user_type)) {
                return failure_callback(res, ['leave_approved_reject_by_user_type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    meeting_check_in: function (req, res, next) {

        try {
            const { tbl_meeting_id, tbl_user_id, tbl_office_id, meeting_check_in_latitude, meeting_check_in_longitude, meeting_check_in_city } = req.body

            if (checkVar(tbl_meeting_id)) {
                return failure_callback(res, ['tbl_meeting_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_office_id)) {
                return failure_callback(res, ['tbl_office_id is required', 400])
            }
            if (checkVar(meeting_check_in_latitude)) {
                return failure_callback(res, ['meeting_check_in_latitude is required', 400])
            }
            
            if (checkVar(meeting_check_in_longitude)) {
                return failure_callback(res, ['meeting_check_in_longitude is required', 400])
            }
            // if (checkVar(meeting_check_in_city)) {
            //     return failure_callback(res, ['meeting_check_in_city is required', 400])
            // }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    /////////////////////////////////////////////////////////// wealthyfy code end here ////////////////////////

  






    forgot_password_API: function (req, res, next) {

        try {
            const { store_email } = req.body

            if (checkVar(store_email)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },










    pagination_validation: function (req, res, next) {

        try {
            const { tbl_store_id,pagesize,pagenumber } = req.body

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(pagesize)) {
                return failure_callback(res, ['pagesize is required', 400])
            }
            if (checkVar(pagenumber)) {
                return failure_callback(res, ['pagenumber is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },
   
    

    


    update_profile: function (req, res, next) {

        try {
            const { user_id,fname,lname,about_self,birthday,gender,height,location,right_or_left_handded,height_type,nationality,hobbies,latitude,longitude } = req.body

            if (checkVar(user_id)) {
                return failure_callback(res, ['user_id is required', 400])
            }
            if (checkVar(fname)) {
                return failure_callback(res, ['fname is required', 400])
            }
            if (checkVar(lname)) {
                return failure_callback(res, ['lname is required', 400])
            }
            if (checkVar(about_self)) {
                return failure_callback(res, ['about_self is required', 400])
            }
            if (checkVar(birthday)) {
                return failure_callback(res, ['birthday is required', 400])
            }
            if (checkVar(gender)) {
                return failure_callback(res, ['gender is required', 400])
            }
            if (checkVar(height)) {
                return failure_callback(res, ['height is required', 400])
            }
            if (checkVar(location)) {
                return failure_callback(res, ['location is required', 400])
            }
            if (checkVar(right_or_left_handded)) {
                return failure_callback(res, ['right_or_left_handded is required', 400])
            }
            if (checkVar(height_type)) {
                return failure_callback(res, ['height_type is required', 400])
            }
            if (checkVar(nationality)) {
                return failure_callback(res, ['nationality is required', 400])
            }
            if (checkVar(hobbies)) {
                return failure_callback(res, ['hobbies is required', 400])
            }
            if (checkVar(latitude)) {
                return failure_callback(res, ['latitude is required', 400])
            }
            if (checkVar(longitude)) {
                return failure_callback(res, ['longitude is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Update_password_api: function (req, res, next) {

        try {
            const {tbl_user_id, old_password, new_password } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(old_password)) {
                return failure_callback(res, ['old_password is required', 400])
            }
            if (checkVar(new_password)) {
                return failure_callback(res, ['new_password is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    create_booking: function (req, res, next) {

        try {
            const {tbl_store_id, sko_name, sko_value, recive_amount,payment_method,tbl_user_id,item_value,consultant_name, shipping_type } = req.body
          

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(sko_name)) {
                return failure_callback(res, ['sko_name is required', 400])
            }
            if (checkVar(sko_value)) {
                return failure_callback(res, ['sko_value is required', 400])
            }
            if (checkVar(recive_amount)) {
                return failure_callback(res, ['recive_amount is required', 400])
            }
            if (checkVar(payment_method)) {
                return failure_callback(res, ['payment_method is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(item_value)) {
                return failure_callback(res, ['item_value is required', 400])
            }
            if (checkVar(consultant_name)) {
                return failure_callback(res, ['consultant_name is required', 400])
            }
            if (checkVar(shipping_type)) {
                return failure_callback(res, ['shipping_type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },




    entry_pending_amount_booking: function (req, res, next) {

        try {
            const {tbl_booking_id,tbl_store_id, sko_name, sko_value, recive_amount,payment_method,tbl_user_id,shipping_type } = req.body

            if (checkVar(tbl_booking_id)) {
                return failure_callback(res, ['tbl_booking_id is required', 400])
            }
            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(sko_name)) {
                return failure_callback(res, ['sko_name is required', 400])
            }
            if (checkVar(sko_value)) {
                return failure_callback(res, ['sko_value is required', 400])
            }
            if (checkVar(recive_amount)) {
                return failure_callback(res, ['recive_amount is required', 400])
            }
            if (checkVar(payment_method)) {
                return failure_callback(res, ['payment_method is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(shipping_type)) {
                return failure_callback(res, ['shipping_type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    create_expenses: function (req, res, next) {

        try {
            const {tbl_store_id, expenses_name, amount, tbl_user_id,payemnt_mode } = req.body

            if (checkVar(expenses_name)) {
                return failure_callback(res, ['expenses_name is required', 400])
            }
            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(payemnt_mode)) {
                return failure_callback(res, ['payemnt_mode is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    add_other_receipt_amount: function (req, res, next) {

        try {
            const {tbl_user_id, tbl_store_id, party_name, amount,payment_mode } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(party_name)) {
                return failure_callback(res, ['party_name is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            if (checkVar(payment_mode)) {
                return failure_callback(res, ['payment_mode is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    keyword_validation: function (req, res, next) {

        try {
            const {keyword } = req.body

            if (checkVar(keyword)) {
                return failure_callback(res, ['keyword is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    update_store_by_user_api: function (req, res, next) {

        try {
            const {tbl_store_id, tbl_user_id } = req.body

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },




    assign_store_list_API: function (req, res, next) {

        try {
            const {tbl_user_id,tbl_store_id } = req.body

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },




    collect_fund_api: function (req, res, next) {

        try {
            const {tbl_store_id, tbl_user_id, amount,payment_type } = req.body

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            if (checkVar(payment_type)) {
                return failure_callback(res, ['payment_type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    search_by_keyword_API: function (req, res, next) {

        try {
            const {keywords,tbl_store_id } = req.body

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['tbl_store_id is required', 400])
            }
            if (checkVar(keywords)) {
                return failure_callback(res, ['keywords is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },




    delivery_status_api: function (req, res, next) {

        try {
            const {tbl_booking_id, delivery_status } = req.body

            if (checkVar(tbl_booking_id)) {
                return failure_callback(res, ['tbl_booking_id is required', 400])
            }
            if (checkVar(delivery_status)) {
                return failure_callback(res, ['delivery_status is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    send_otp_API: function (req, res, next) {

        try {
            const { mobile,amount   } = req.body

            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    today_cash_collection_KSO_wise_APi: function (req, res, next) {

        try {
            const { tbl_store_id,type   } = req.body

            if (checkVar(tbl_store_id)) {
                return failure_callback(res, ['mobile is required', 400])
            }
            if (checkVar(type)) {
                return failure_callback(res, ['type is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },
   








}